import pandas as pd   
import pickle

# Assuming the sorted dataset is loaded as a DataFrame named 'sorted_fastfood'
  
# Define the keywords to filter non-vegetarian items
non_veg_keywords = ['chicken', 'beef', 'pork', 'bacon', 'fish', 'shrimp', 'turkey', 'sausage']
  
# Make the filtering case-insensitive
sorted_fastfood['item_lower'] = sorted_fastfood['item'].str.lower()
  
# Filter vegetarian items
sorted_fastfood['is_vegetarian'] = ~sorted_fastfood['item_lower'].str.contains('|'.join(non_veg_keywords))
  
# Find the top vegetarian option
top_vegetarian = sorted_fastfood[sorted_fastfood['is_vegetarian']].tail(1)
  
# Find the top 4 healthiest non-vegetarian options
top_non_vegetarian = sorted_fastfood[~sorted_fastfood['is_vegetarian']].tail(4)
  
# Combine the top vegetarian and non-vegetarian options
top_healthy_options = pd.concat([top_vegetarian, top_non_vegetarian])
  
# Drop the 'item_lower' and 'is_vegetarian' columns as they are not needed anymore
top_healthy_options = top_healthy_options.drop(columns=['item_lower', 'is_vegetarian'])
  
print(top_healthy_options)
pickle.dump(top_healthy_options,open("./ref_result/top_healthy_options.pkl","wb"))

